@extends('layouts.app-form')

@section('form-title')
    @if(isset($detail))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection

@push('styles')
<style>
  .form-control{
    padding: .5rem 0.5rem !important;
  }
</style>
@endpush


@section('form')
    @if(isset($detail))
        <input type="hidden" name="_method" value="PUT">
    @endif
    <div class="row">

      <div class="col-md-3">
        <div class="form-group">
          <label for="tgl_pengeluaran" class="form-label">Tanggal<span class="text-danger">*</span> </label>
          <input class="form-control" type="date" name="tgl_pengeluaran" required value="{{ date('Y-m-d') }}">
          @error('tgl_pengeluaran')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
    </div>

    <div class="row mb-5">
      <div class="col-md-12">
        <table class="table" style="font-size: 11px;">
          <thead>
            <tr>
              <th width="25%">Akun<span class="text-danger">*</span></th>
              <th width="20%">Deskripsi<span class="text-danger">*</span></th>
              <th width="20%">Debit<span class="text-danger">*</span></th>
              <th width="20%">Kredit</th>
            </tr>
          </thead>
          <tbody>
            @if(isset($detail))
            <tr>
              <td>
                <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
                  <option value="">Pilih Akun</option>
                  @foreach ($akuns as $akun)
                  <option value="{{ $akun->id }}" @if($akun->id == $detail->akun_id) selected @endif >{{ $akun->nama_akun }}</option>
                  @endforeach
                </select>
                @error('akun_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="desc[]" required value="{{ $detail->description }}">
                @error('desc')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="debet[]" value="{{ $detail->debet }}" >
                @error('biaya')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="kredit[]" value="{{ $detail->kredit }}">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
            </tr>


            @else
            <tr>
              <td>
                <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
                  <option value="">Pilih Akun</option>
                  @foreach ($akuns as $akun)
                  <option value="{{ $akun->id }}">{{ $akun->nama_akun }}</option>
                  @endforeach
                </select>
                @error('akun_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="desc[]" required>
                @error('desc')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="debet[]" >
                @error('biaya')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="kredit[]">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
            </tr>


            @endif


          </tbody>
        </table>
        @if(!isset($detail))
        <button type="button" class="btn btn-sm btn-primary addButton"> <i class="fa-solid fa-plus"></i> Tambah Biaya </button>
        @endif
      </div>
    </div>

    <div class="row mb-5">
      <div class="offset-md-5 col-md-4">
        <div class="row">
          <div class="col-md-6">
            {{-- <p> Total </p> --}}
            {{-- <p class="fw-bolder"> Uang Muka (Rp.) </p> --}}
          </div>
          <div class="col-md-6 text-end">
            {{-- <p id="total"> 0 </p> --}}
            {{-- <input style="width: 80%;" class="form-control money float-end text-end" type="text" name="uang_muka" value="{{ old('uang_muka',@$data->uang_muka) }}"> --}}
          </div>
          
          <div class="col-md-6">
            <p>Total Kredit</p>
            <h5 style="color: #8A92A5">Total Debet</h5>
          </div>
          <div class="col-md-6 text-end">
            <p id="kredit">0</p>
            <h5 style="color: #8A92A5" id="debet">0</h5>
          </div>
        </div>
      </div>
    </div>
    
@endsection

@push('scripts')
<script>
  $(document).ready(function(){
    // Function Wrapper
    /*
    Function Convert String To Number
    */
    function toNumber(string){
      return parseInt(string.replace(/\./g, ''))
    }

    /*
    Function Format Uang
    */
    function money(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }


    function hitungTotal(){
      let total = 0;
    //   $('input[name="jumlah[]"]').each(function(index, el) {
    //     total += toNumber($(this).val());
    //   });

      let kredit = 0;
      $('input[name="kredit[]"]').each(function(index, el) {
        if($(this).val()){
            kredit += toNumber($(this).val());
        }
          
      });
      let debet = 0;
      $('input[name="debet[]"]').each(function(index, el) {
        if($(this).val()){
            debet += toNumber($(this).val());
        }
          
      });
      // $('#total').html("Rp. " + money(total));
      $('#kredit').html("Rp. " + money(kredit));
      $('#debet').html("Rp. " + money(debet));
    }

    /*
    Function Hitung Per Produk
    */
    function hitungJumlah(el){

      hitungTotal();
    }

    function init(){
      $('.money').mask('000.000.000.000.000', {reverse: true});
      $('.phone').mask('0000-0000');
      $('.select2').select2();

      $('input[name="debet[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="kredit[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

    //   $('input[name="pajak[]"]').keyup(function (e) { 
    //     hitungJumlah(this);
    //   });
      
    //   $('input[name="pajak_lain[]"]').keyup(function (e) { 
    //     hitungJumlah(this);
    //   });

    //   $('input[name="pemotongan"]').keyup(function (e) { 
    //     hitungTotal(this);
    //   });

      // $('input[name="uang_muka"]').keyup(function (e) { 
      //   hitungTotal();
      // }); 
    }


    // End Function Wrapper

    $('aside.sidebar').addClass('sidebar-mini');

    $("#diskon_rp").click(function (e) { 
      $('input[name="tipe_diskon"]').val('rp');
      tipeDiskon = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_persen").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
        hitungJumlah(this)
      });
    });

    $("#diskon_persen").click(function (e) { 
      tipeDiskon = "persen";
      $('input[name="tipe_diskon"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_rp").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
        hitungJumlah(this)
      });
    });
    $("#pemotongan_rp").click(function (e) { 
      $('input[name="tipe_pemotongan"]').val('rp');
      tipePemotongan = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_persen").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    $("#pemotongan_persen").click(function (e) { 
      tipePemotongan = "persen";
      $('input[name="tipe_pemotongan"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_rp").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    let addButton = $('.addButton');
    let wrapper = $('tbody');
    let fieldHtml = `
    <tr>
        <td>
            <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
              <option value="">Pilih Akun</option>
              @foreach ($akuns as $akun)
              <option value="{{ $akun->id }}">{{ $akun->nama_akun }}</option>
              @endforeach
            </select>
            @error('akun_id')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control" type="text" name="desc[]" required>
            @error('desc')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="debet[]">
            @error('diskon')
                <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="kredit[]" >
            @error('jumlah')
              <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
              <td>
                <a class="removeButton"><i class="fa-solid fa-minus"></i></a>
              </td>
    </tr>
    `;

    $(addButton).click(function(){
      $(wrapper).append(fieldHtml); //Add field html

      init();
    });

    $(wrapper).on('click', '.removeButton', function(e){
        e.preventDefault();
        $(this).parent().parent().remove(); //Remove field html
    });

    init();
    
    let isEditForm = "{{ @$data }}";
    if(isEditForm.length){
      hitungTotal();
    }

    let pajakInput = document.getElementsByClassName('pajak');
    let pajakLainInput = document.getElementsByClassName('pajak_lain');

    for (let index = 0; index < pajakInput.length; index++) {
      pajakInput[index].addEventListener('keyup',(event,pajakLainInput)=>{
        pajakLainInput = document.getElementsByClassName('pajak_lain');
        pajakLainInput[index].value = null;
      });
      
    }

    for (let index = 0; index < pajakLainInput.length; index++) {
      pajakLainInput[index].addEventListener('keyup',(event,pajakInput)=>{
        pajakInput = document.getElementsByClassName('pajak');
        pajakInput[index].value = null;
      });
      
    }
    console.log(pajakInput.length, pajakLainInput.length)

    
  });
</script>
@endpush