@extends('layouts.index')

@section('breadcrumb')
@include('layouts.include._breadcrumb')    
@endsection

@section('content')

<div class="row">
  <div class="col-sm-12">
     <div class="card">
        <div class="card-header d-flex justify-content-between">
           <div class="header-title">
              <h4 class="card-title">{{ $settings['title'] }}</h4>
            </div>
        </div>
        <div class="card-body">
           <div class="table-responsive">
              <table id="datatable" class="table" data-toggle="data-table">
                 <thead>
                    <tr>
                       <th>Date</th>
                       <th>Description</th>
                       <th>Person</th>
                       <th>Debit</th>
                       <th>Kredit</th>
                       <th>Balance</th>
                    </tr>
                 </thead>
                 <tbody>
                   @foreach ($data->jurnal as $jurnal)
                   <tr>
                     <td>{{ $jurnal->tanggal }}</td>
                     <td class="text-primary">
                        {!! $jurnal->desc !!}
                     </td>
                     <td>{{ $jurnal->person }}</td>
                     <td>Rp. {{  number_format($jurnal->debet ?? 0) }}</td>
                     <td>Rp. {{  number_format($jurnal->kredit ?? 0) }}</td>
                     <td>Rp. {{  number_format($jurnal->balance ?? 0) }}</td>
                   </tr>
                   @endforeach
                 </tfoot>
              </table>
           </div>
        </div>
     </div>
  </div>
</div>
@endsection