@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
      {{ $settings['title'] }}
    @else
      {{ $settings['title'] }}
    @endif
@endsection


@section('form')
<table class="table">
  <thead>
     <tr>
        <th>No</th>
        <th>Kode Akun</th>
        <th>Nama Akun</th>
        <th>Debet</th>
        <th>Kredit</th>
     </tr>
  </thead>
  <tbody>
    @foreach ($datas as $data)
    <tr>
      <td>{{ $loop->iteration }}</td>
      <td>{{ $data->kode_akun }}</td>
      <td class="text-primary">
         <a href="{{ route($settings['route'].'.show', $data->id) }}">{{ $data->nama_akun }}</a>
      </td>
      <td>
        <input class="form-control money debet" type="text" value="{{ @\Helper::findAkunEkuitas($data->id)->debet ?? 0 }}" @if($data->nama_akun == 'Pembukaan Saldo Ekuitas') readonly @else name="debet[]" @endif>
      </td>
      <td>
        <input class="form-control money kredit" type="text" value="{{ @\Helper::findAkunEkuitas($data->id)->kredit ?? 0 }}" @if($data->nama_akun == 'Pembukaan Saldo Ekuitas') readonly @else name="kredit[]" @endif>
      </td>
    </tr>
    @endforeach
  </tfoot>
  <tfoot>
    <tr>
      <td colspan="3" align="right"> Total :</td>
      <td id="totalDebet"></td>
      <td id="totalKredit"></td>
    </tr>
  </tfoot>
</table>

<i class="text-danger">Catatan : Harap konfirmasi untuk mempublikasikan saldo awal dengan ketentuan di bawah ini: Jumlah debit dan kredit harus seimbang. Jika terdapat selisih.., selisih tersebut akan diposkan ke rekening <b>Pembukaan Saldo Ekuitas</b> .</i>
@endsection

@push('scripts')
<script>
  $(document).ready(function() {
    $('aside.sidebar').addClass('sidebar-mini');

    /*
    Function Convert String To Number
    */
    function toNumber(string){
      return parseInt(string.replace(/\./g, ''))
    }

    /*
    Function Format Uang
    */
    function money(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    $('form').submit(function (e) { 
      let totalDebet = 0;
      let totalKredit = 0;

      // Hitung Total Debet
      $('.debet').each(function(index, el) {
        var debet = toNumber($(this).val());
        if(debet){
          totalDebet += parseInt(debet);
        }
      });

      // Hitung Total Kredit
      $('.kredit').each(function(index, el) {
        var kredit = toNumber($(this).val());
        if(kredit){
          totalKredit += parseInt(kredit);
        }
      });

      if(totalDebet != totalKredit){
        alert('Jumlah debet dan kredit terdapat selisih sebanyak Rp. ' + money(Math.abs(totalDebet - totalKredit)) + ' , selisih tersebut akan dimasukkan ke akun Pembukaan Saldo Ekuitas.');
      }

      
    });

    function hitungTotal(){
      var totalDebet = 0;
      var totalKredit = 0;

      // Hitung Total Debet
      $('.debet').each(function(index, el) {
        var debet = toNumber($(this).val());
        if(debet){
          totalDebet += parseInt(debet);
        }
      });
      $('#totalDebet').html('Rp. '+ money(totalDebet));

      // Hitung Total Kredit
      $('.kredit').each(function(index, el) {
        var kredit = toNumber($(this).val());
        if(kredit){
          totalKredit += parseInt(kredit);
        }
      });
      $('#totalKredit').html('Rp. '+ money(totalKredit));
    }

    hitungTotal();
    
    $('.debet').keyup(function (e) { 
      hitungTotal();
    });

    $('.kredit').keyup(function (e) { 
      hitungTotal();
    });
  });
</script>
@endpush