@extends('layouts.index')

@section('breadcrumb')
@include('layouts.include._breadcrumb')    
@endsection

@section('content')

<div class="row">
  <div class="col-sm-12">
     <div class="card">
        <div class="card-header d-flex justify-content-between">
           <div class="header-title">
              <h4 class="card-title">{{ $settings['title'] }}</h4>
            </div>
            @if (Helper::cek_akses($settings['title'], 'Tambah'))
            <div class="row">
               <div class="col-md-12">
                  <a href="{{ route($settings['route'].'.opening') }}" class="btn btn-sm btn-warning float-right"> <i class="fa fa-eye"></i> Pembukaan Saldo</a>
   
                  <a href="{{ route($settings['route'].'.create') }}" class="btn btn-sm btn-primary float-right">+ Tambah Akun</a>
               </div>
            </div>
            @endif
        </div>
        <div class="card-body">
           <div class="table-responsive">
              <table id="datatable" class="table" data-toggle="data-table">
                 <thead>
                    <tr>
                       <th>No</th>
                       <th>Kode Akun</th>
                       <th>Nama Akun</th>
                       <th>Kategori Akun</th>
                       <th>Saldo</th>
                       <th>Aksi</th>
                    </tr>
                 </thead>
                 <tbody>
                   @foreach ($datas as $data)
                   <tr>
                     <td>{{ $loop->iteration }}</td>
                     <td>{{ $data->kode_akun }}</td>
                     <td class="text-primary">
                        <a href="{{ route($settings['route'].'.show', $data->id) }}">{{ $data->nama_akun }}</a>
                     </td>
                     <td class="text-primary">
                        <a href="{{ route($settings['route'].'.index', ['kategori_id' => $data->kategori->id]) }}">{{ $data->kategori->nama_kategori }}</a>
                     </td>
                     <td>Rp. {{  number_format($data->saldo) }}</td>
                     @include('layouts.include.basic-action')
                   </tr>
                   @endforeach
                 </tfoot>
              </table>
           </div>
        </div>
     </div>
  </div>
</div>
@endsection