@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection


@section('form')
    @if(isset($data))
        <input type="hidden" name="_method" value="PUT">
    @endif
    <div class="form-group">
      <label for="kode_akun" class="form-label">Kode Akun <span class="text-danger">*</span> </label>
      <input class="form-control" type="text" name="kode_akun" required value="{{ old('kode_akun',@$data->kode_akun) }}">
      @error('kode_akun')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>

    <div class="form-group">
      <label for="nama_akun" class="form-label">Nama Akun <span class="text-danger">*</span> </label>
      <input class="form-control" type="text" name="nama_akun" required value="{{ old('nama_akun',@$data->nama_akun) }}">
      @error('nama_akun')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>

    <div class="form-group">
      <label for="kategori_akun_id" class="label-control">Kategori Akun <span class="text-danger">*</span></label>
      <select class="form-control select2" name="kategori_akun_id" id="kategori_akun_id" tabindex="-1" required>
          @foreach ($kategoris as $kategori)
          <option value="{{ $kategori->id }}" @if($kategori->id == old('kategori_akun_id',@$data->kategori_akun_id)) selected @endif>{{ $kategori->nama_kategori }}</option>
          @endforeach
      </select>
      @error('kategori_akun_id')
          <strong class="text-danger">{{ $message }}</strong>
      @enderror
  </div>
@endsection