<?php

namespace Database\Seeders;

use App\Models\Menu;
use App\Models\KategoriAkun;
use App\Models\Akun;
use App\Models\Pelanggan;
use App\Models\Supplier;
use App\Models\Level;
use App\Models\User;
use App\Models\Produk;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Menu::insert([
            // Menu Level 
            [
                'nama_menu' => 'Level',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Level',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Level',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Level',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Master User 
            [
                'nama_menu' => 'User',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'User',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'User',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'User',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Chart Of Account
            [
                'nama_menu' => 'Chart Of Account',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Chart Of Account',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Chart Of Account',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Chart Of Account',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Jurnal Umum 
            [
                'nama_menu' => 'Jurnal Umum',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Jurnal Umum',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Jurnal Umum',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Jurnal Umum',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Pelanggan
            [
                'nama_menu' => 'Pelanggan',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Pelanggan',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Pelanggan',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Pelanggan',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Supplier
            [
                'nama_menu' => 'Supplier',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Supplier',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Supplier',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Supplier',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Produk
            [
                'nama_menu' => 'Produk',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Produk',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Produk',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Produk',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Penjualan
            [
                'nama_menu' => 'Penjualan',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Penjualan',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Penjualan',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Penjualan',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Pembelian
            [
                'nama_menu' => 'Pembelian',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Pembelian',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Pembelian',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Pembelian',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Pengeluaran
            [
                'nama_menu' => 'Pengeluaran',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Pengeluaran',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Pengeluaran',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Pengeluaran',
                'aksi_menu' => 'Hapus',
            ],
            // Menu Aset
            [
                'nama_menu' => 'Aset',
                'aksi_menu' => 'Lihat',
            ],
            [
                'nama_menu' => 'Aset',
                'aksi_menu' => 'Tambah',
            ],
            [
                'nama_menu' => 'Aset',
                'aksi_menu' => 'Ubah',
            ],
            [
                'nama_menu' => 'Aset',
                'aksi_menu' => 'Hapus',
            ],
            //Laporan
            [
                'nama_menu' => 'Laporan',
                'aksi_menu' => 'Lihat',
            ],
           
        ]);

        Produk::create([
            'nama_produk'=>'Batu Bara',
            'satuan'=>'Kg',
            'harga_jual'=>10000,
            'harga_beli'=>5000,
            'stok_awal'=>'1000',
            'stok'=>'1000',
         ]);

        $level = Level::create([
            'nama_level' => 'Admin'
        ]);

        for ($i=1; $i <= Menu::all()->count() ; $i++) { 
            $level->Menu()->attach($i);
        }

        $user = User::create([
            'level_id' => $level->id,
            'nama' => 'Admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('admin1234'),
        ]);

        Pelanggan::create([
            'nama_pelanggan'=>"Umum",
            'no_telp'=>"-",
            'alamat'=>"-",
        ]);

        Supplier::create([
            'nama_supplier'=>"Pt Coal",
            'no_telp'=>"-",
            'alamat'=>"-",
        ]);

        KategoriAkun::insert([
            // 1. Kas
            [
                'nama_kategori'=>"Cash & Bank",
                'lock'=>"no",
            ],
            // 2. Piutang Usaha
            [
                'nama_kategori'=>"Piutang Usaha",
                'lock'=>"yes",
            ],
            // 3. Persediaan
            [
                'nama_kategori'=>"Persediaan",
                'lock'=>"yes",
            ],
            // 4. Akun Hutang
            [
                'nama_kategori'=>"Hutang Usaha",
                'lock'=>"yes",
            ],
            // 5. Pendapatan
            [
                'nama_kategori'=>"Pendapatan",
                'lock'=>"yes",
            ],
            // 6. Beban
            [
                'nama_kategori'=>"Beban",
                'lock'=>"no",
            ],
            // 7. Pembukaan Saldo Ekuitas
            [
                'nama_kategori'=>"Pembukaan Saldo Ekuitas",
                'lock'=>"yes",
            ],
            // 8. Kewajiban Lancar Lainnya
            [
                'nama_kategori'=>"Kewajiban Lancar Lainnya",
                'lock'=>"yes",
            ],
        ]);

        Akun::insert([
            [
                'kategori_akun_id'=>1,
                'kode_akun'=>"1-10001",
                'nama_akun'=>"Kas",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>1,
                'kode_akun'=>"1-10002",
                'nama_akun'=>"Akun Bank",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>2,
                'kode_akun'=>"1-10100",
                'nama_akun'=>"Akun Piutang",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>3,
                'kode_akun'=>"1-10200",
                'nama_akun'=>"Akun Persediaan",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>4,
                'kode_akun'=>"2-20100",
                'nama_akun'=>"Akun Hutang",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>5,
                'kode_akun'=>"4-40000",
                'nama_akun'=>"Akun Pendapatan",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>5,
                'kode_akun'=>"4-40100",
                'nama_akun'=>"Diskon Penjualan",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>6,
                'kode_akun'=>"5-50000",
                'nama_akun'=>"Biaya Penjualan (HPP)",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>6,
                'kode_akun'=>"6-60101",
                'nama_akun'=>"Gaji",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>6,
                'kode_akun'=>"6-60211",
                'nama_akun'=>"Sarana Kantor",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>6,
                'kode_akun'=>"6-60300",
                'nama_akun'=>"Beban Kantor",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>7,
                'kode_akun'=>"7-00000",
                'nama_akun'=>"Pembukaan Saldo Ekuitas",
                'lock'=>'yes',
                'saldo'=>0,
            ],
            [
                'kategori_akun_id'=>8,
                'kode_akun'=>"9-120",
                'nama_akun'=>"PPN Keluaran",
                'lock'=>'yes',
                'saldo'=>0,
            ],
        ]);

    }
}
