<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJurnalUmumsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jurnal_umums', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('akun_id')->constrained();
            $table->date('tanggal');
            $table->string('opening_akun')->nullable(); // Buat Opening Awal

            $table->foreignId('pelanggan_id')->nullable()->constrained();
            $table->foreignId('supplier_id')->nullable()->constrained();

            $table->foreignId('penjualan_id')->nullable()->constrained();
            $table->foreignId('pembayaran_penjualan_id')->nullable()->constrained();
            $table->foreignId('pembelian_id')->nullable()->constrained();
            $table->foreignId('pembayaran_pembelian_id')->nullable()->constrained();
            $table->foreignId('pengeluaran_id')->nullable()->constrained();
            $table->foreignId('pembayaran_pengeluaran_id')->nullable()->constrained();

            $table->bigInteger('debet')->nullable();
            $table->bigInteger('kredit')->nullable();

            $table->string('description')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jurnal_umums');
    }
}
