<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePembayaranPenjualansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pembayaran_penjualans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('akun_id')->constrained();
            $table->date('tgl_bayar');
            $table->foreignId('penjualan_id')->constrained();
            $table->bigInteger('jumlah_bayar');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pembayaran_penjualans');
    }
}
