<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePenjualansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('penjualans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('pelanggan_id')->constrained();
            $table->foreignId('pemotongan_akun_id')->nullable()->constrained('akuns');
            $table->date('tgl_transaksi');
            $table->date('tgl_jatuh_tempo');
            $table->string('no_transaksi');
            $table->text('catatan')->nullable();
            $table->bigInteger('total')->nullable();
            $table->bigInteger('pemotongan')->nullable();
            $table->enum('status', ['paid', 'pending', 'overdue']);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('penjualans');
    }
}
