<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAkunTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('akuns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('lock', ['yes', 'no'])->default('no'); // no = boleh ubah/hapus akun, yes = tidak boleh ubah/hapus akun
            $table->foreignId('kategori_akun_id')->constrained();
            $table->string('kode_akun');
            $table->string('nama_akun');
            $table->bigInteger('saldo');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('akuns');
    }
}
