<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supplier extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded =[];

    public function pembelian()
    {
        return $this->hasMany(Pembelian::class);
    }

    public function getInvoiceAttribute()
    {
        $invoice = array();
        foreach ($this->pembelian as $pembelian) {
            $total_bayar = 0;
            foreach ($pembelian->pembayaran as $pembayaran) {
                $total_bayar += $pembayaran->jumlah_bayar;
            }
            $invoice[] = [
                "id" => $pembelian->id,
                "no_transaksi" => $pembelian->no_transaksi,
                "hutang" => $pembelian->total - $total_bayar
            ];
        }

        // dd($invoice);
        // $collection = collect($invoice);
        // dd($collection);
        return $invoice;
    }
}
