<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pengeluaran extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $guarded =[];

    public function JurnalUmum(){
        return $this->hasMany(JurnalUmum::class);
    }

    public function detail(){
        return $this->hasMany(DetailPengeluaran::class);
    }

    public function pembayaran(){
        return $this->hasMany(PembayaranPengeluaran::class);
    }

    public function akunPemotongan(){
        return $this->belongsTo(Akun::class, 'pemotongan_akun_id')->withTrashed();
    }

    public function getDebetAttribute(){
        $debet = 0;
        foreach ($this->jurnalUmum as $jurnalUmum) {
            $debet += $jurnalUmum->debet;
        }
        return $debet;
    }

    public function getKreditAttribute(){
        $kredit = 0;
        foreach ($this->jurnalUmum as $jurnalUmum) {
            $kredit += $jurnalUmum->kredit;
        }
        return $kredit;
    }

    public function getJumlahTerbayarAttribute(){
        $jumlah = 0;
        foreach ($this->pembayaran as $pembayaran) {
            $jumlah += $pembayaran->jumlah_bayar;
        }
        return $jumlah;
    }

    public function getSisaTagihanAttribute(){
        return $this->total - $this->jumlah_terbayar;
    }
    
    public function getStatusButtonAttribute(){
        $button = '';
        if($this->status == 'paid')
            $button = 'success';
        elseif($this->status == 'pending')
            $button = 'warning';
        else
            $button = 'danger';

        return $button;
    }

    // this is a recommended way to declare event handlers
    public static function boot() {
        parent::boot();

        static::deleting(function($data) { // before delete() method call this
            $data->JurnalUmum()->delete();
            // do the rest of the cleanup...
        });
    }
}
