<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PembayaranPenjualan extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded =[];

    public function JurnalUmum(){
        return $this->hasMany(JurnalUmum::class);
    }

    public function akun(){
        return $this->belongsTo(Akun::class);
    }

    public function Penjualan(){
        return $this->belongsTo(Penjualan::class);
    }

    // this is a recommended way to declare event handlers
    public static function boot() {
        parent::boot();

        static::deleting(function($data) { // before delete() method call this
            $data->JurnalUmum()->delete();
            // do the rest of the cleanup...
        });
    }
}
