<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Collection;

class Pelanggan extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded =[];

    public function penjualan(){
        return $this->hasMany(Penjualan::class);
    }

    public function getPiutangAttribute()
    {   
        $total = 0;
        $total_penjualan = 0;
        $total_bayar = 0;
        
        foreach($this->penjualan as $penjualan){
            $total_penjualan += $penjualan->total;
            foreach ($penjualan->pembayaran as $pembayaran) {
                $total_bayar += $pembayaran->jumlah_bayar;
            }
        }

        $total = $total_penjualan - $total_bayar;

        return $total;

    }

    public function getInvoiceAttribute()
    {
        $invoice = array();
        foreach ($this->penjualan as $penjualan) {
            $total_bayar = 0;
            foreach ($penjualan->pembayaran as $pembayaran) {
                $total_bayar += $pembayaran->jumlah_bayar;
            }
            $invoice[] = [
                "id"=>$penjualan->id,
                "no_transaksi" => $penjualan->no_transaksi,
                "piutang" => $penjualan->total - $total_bayar
            ];
        }

        // dd($invoice);
        // $collection = collect($invoice);
        // dd($collection);
        return $invoice;
    }
}
