<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use PhpParser\Node\Stmt\Switch_;

class JurnalUmum extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded =[];

    public function Akun(){
        return $this->belongsTo(Akun::class)->withTrashed();
    }

    public function Pelanggan(){
        return $this->belongsTo(Pelanggan::class)->withTrashed();
    }

    public function Supplier(){
        return $this->belongsTo(Supplier::class)->withTrashed();
    }

    public function Penjualan(){
        return $this->belongsTo(Penjualan::class);
    }

    public function PembayaranPenjualan(){
        return $this->belongsTo(PembayaranPenjualan::class);
    }

    public function Pembelian(){
        return $this->belongsTo(Pembelian::class);
    }

    public function PembayaranPembelian(){
        return $this->belongsTo(PembayaranPembelian::class);
    }

    public function Pengeluaran(){
        return $this->belongsTo(Pengeluaran::class);
    }

    public function PembayaranPengeluaran(){
        return $this->belongsTo(PembayaranPengeluaran::class);
    }

    public function getPersonAttribute(){
        return ($this->supplier_id) ? $this->Supplier->nama_supplier : ($this->pelanggan_id ? $this->pelanggan->nama_pelanggan : '-');
    }

    public function getDescAttribute(){
        $desc = '-';

        if($this->Penjualan){
            $text = $this->description ?? "Make Sales";
            $desc = '<a target="_blank" href=" '.route('penjualan.show', $this->penjualan_id).'"> '.$text.' : '.$this->Penjualan->no_transaksi.'</a>';
        }else if($this->Pembelian){
            $desc = '<a target="_blank" href=" '.route('pembelian.show', $this->pembelian_id).'"> Make Purchase : '.$this->Pembelian->no_transaksi.'</a>';
        }else if($this->Pengeluaran){
            $desc = '<a target="_blank" href=" '.route('pengeluaran.show', $this->pengeluaran_id).'"> Make Expenses : '.$this->Pengeluaran->no_pengeluaran.'</a>';
        }else if($this->PembayaranPenjualan){
            $desc = '<a target="_blank" href=" '.route('penjualan.show', $this->PembayaranPenjualan->penjualan_id).'"> Paid Sales : '.$this->PembayaranPenjualan->penjualan->no_transaksi.'</a>';
        }else if($this->PembayaranPembelian){
            $desc = '<a target="_blank" href=" '.route('pembelian.show', $this->PembayaranPembelian->pembelian_id).'"> Paid Purchase : '.$this->PembayaranPembelian->pembelian->no_transaksi.'</a>';
        }else if($this->PembayaranPengeluaran){
            $desc = '<a target="_blank" href=" '.route('pengeluaran.show', $this->PembayaranPengeluaran->pengeluaran_id).'"> Paid Expenses : '.$this->PembayaranPengeluaran->pengeluaran->no_pengeluaran.'</a>';
        }else if($this->opening_akun == 'yes'){
            $desc = 'Opening Akun';
        }

        return $desc;
    }

    public function getBalanceAttribute(){
        $debet = 0;
        $kredit = 0;
        $balance = 0;

        foreach($this->akun->jurnal as $jurnal){
            $debet += $jurnal->debet;
            $kredit += $jurnal->kredit;
            $balance = abs($debet - $kredit);
            if($jurnal->id == $this->id){
                break;
            }
        }

        return $balance;
    }
}
