<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetailPenjualan extends Model
{
    use HasFactory;

    protected $guarded =[];

    public function produk(){
        return $this->belongsTo(Produk::class)->withTrashed();
    }

    public function getSubTotalAttribute(){
        // Harga * Qty - diskon + Pajak
        return $this->harga * $this->qty - $this->diskon + (($this->harga * $this->qty - $this->diskon) * $this->pajak / 100);
    }
}
