<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetailPengeluaran extends Model
{
    use HasFactory;

    protected $guarded =[];

    public function akun(){
        return $this->belongsTo(Akun::class)->withTrashed();
    }
    public function getSubTotalAttribute(){
        // Harga * Qty - diskon + Pajak
        return $this->biaya - $this->diskon + (($this->biaya - $this->diskon) * $this->pajak / 100);
    }
}
