<?php

namespace App\Models;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Helpers\Helper;

class Akun extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded =[];

    public function Jurnal(){
        return $this->hasMany(JurnalUmum::class)->orderBy('tanggal', 'asc');
    }

    public function kategori(){
        return $this->belongsTo(KategoriAkun::class, 'kategori_akun_id')->withTrashed();
    }

    public function getSaldoAttribute(){
        $debet = 0;
        $kredit = 0;
        $balance = 0;

        foreach($this->jurnal as $jurnal){
            $debet += $jurnal->debet;
            $kredit += $jurnal->kredit;
            $balance = abs($debet - $kredit);
        }

        return $balance;
    }

    public function getDebetAttribute(){
        $debet = 0;

        foreach($this->jurnal as $jurnal){
            $debet += $jurnal->debet;
        }

        return $debet;
    }

    public function getKreditAttribute(){
        $kredit = 0;

        foreach($this->jurnal as $jurnal){
            $kredit += $jurnal->kredit;
        }

        return $kredit;
    }

    // public function getSaldoAttribute(){
    //     // dd($this->date);
    //     $request = resolve(Request::class);
    //     $date1 = $request->get('date');
    //     $date2 = $request->get('date2');
    //     if(isset($date1)){
    //         $date1 = $date1." 00:00:00";
    //         $date2 = $date2." 23:59:59";
    //     }else{
    //         $date1 = null;
    //         $date2 = null;
    //     }

    //     // dd($date2);
    //     // dd($date1);
    //     switch ($this->nama_akun) {
    //         case 'Kas':
    //             return Helper::hitungSaldoKas($date1,$date2);
    //             break;

    //         case 'Pendapatan':
    //             return Helper::hitungSaldoPendapatan($date1,$date2);
    //             break;

    //         case 'Beban Pokok Pendapatan':
    //             return Helper::hitungSaldoBebanPokokPendapatan($date1,$date2);
    //             break;

    //         case 'Piutang Usaha':
    //             return Helper::hitungSaldoPiutangUsaha($date1,$date2);
    //             break;

    //         case 'Persediaan Barang':
    //             return Helper::hitungPersediaanBarang($date1,$date2);
    //             break;

    //         case 'Hutang Usaha':
    //             return Helper::hitungSaldoHutangUsaha($date1,$date2);
    //             break;

    //         case 'Gaji':
    //             return Helper::hitungSaldoPengeluaran($this->id,$date1,$date2);
    //             break;
            
    //         case 'Sarana Kantor':
    //             return Helper::hitungSaldoPengeluaran($this->id,$date1,$date2);
    //             break;

    //         case 'Beban Kantor':
    //             return Helper::hitungSaldoPengeluaran($this->id,$date1,$date2);
    //             break;
            
    //         case 'Pajak Masukkan':
    //             return Helper::hitungTotalPajakMasukkan($date1,$date2);

    //         case 'Pajak Keluaran':
    //             return Helper::hitungTotalPajakKeluaran($date1,$date2);

    //         case 'Pemakaian Pribadi':
    //             return Helper::hitungTotalPemakaianPribadi($date1,$date2);
            
    //         default:
    //             return "Rp. 0";
    //             break;
    //     }
    // }
}
