<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Level;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{

    protected $routeName = 'user';
    protected $viewName = 'user';
    protected $menu = 'Master Data';
    protected $title = 'User';

    protected $aksesMenu = 'User';
    
    public function index()
    {
        if(!\Helper::cek_akses($this->aksesMenu)){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'ubah'=>\Helper::cek_akses($this->aksesMenu,'Ubah'),
            'hapus'=>\Helper::cek_akses($this->aksesMenu,'Hapus')
        ];

        $datas = User::all();
        
        return view($this->viewName.'.index', compact('settings', 'datas'));
    }
    
    public function create()
    {
        if(!\Helper::cek_akses($this->aksesMenu, 'Tambah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=> route($this->routeName.'.store'),
        ];

        $levels = Level::all();
        
        return view($this->viewName.'.form', compact('settings', 'levels'));
    }
    
    public function store(Request $request)
    {
        if (!\Helper::cek_akses($this->aksesMenu, 'Tambah')) {
            return abort(404);
        }

        $request->validate([
            'nama' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
            'password_confirm' => 'required|same:password',
            'level_id' => 'required',
        ]);

        DB::beginTransaction();
        try {

            $user = User::create([
                'nama' => $request->nama,
                'email' => $request->email,
                'level_id' => $request->level_id,
                'password' => bcrypt($request->password),
            ]);
            
            \Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $user->nama,$user->toArray());

            DB::commit();
            
            return redirect(route($this->routeName . '.index'))->with(['success' => 'Berhasil Menambah Data ' . $this->aksesMenu]);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => 'Gagal Menambah Data ' . $this->aksesMenu . ' : ' . $e->getMessage()])->withInput($request->all());
        }
    }

    public function show($id)
    {
        //
    }
    
    public function edit(user $user)
    {
        if(!\Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=>route($this->routeName.'.update',$user->id),
        ];

        $levels = Level::all();

        return view($this->viewName.'.form',compact('settings', 'levels'),['data'=>$user]);
    }

    public function update(Request $request, user $user)
    {
        if (!\Helper::cek_akses($this->aksesMenu, 'Ubah')) {
            return abort(404);
        }

        $request->validate([
            'nama' => 'required',
            'email' => 'required|unique:users,email,' . $user->id,
            'level_id' => 'required',
        ]);

        $password = null;
        if ($request->password || $request->password_confirm) {
            $request->validate([
                'password' => 'required',
                'password_confirm' => 'required|same:password',
            ]);

            $password = bcrypt($request->password);
        }
        DB::beginTransaction();
        try {

            $old = $user->toArray();

            $user->update([
                'email' => $request->email,
                'level_id' => $request->level_id,
                'nama' => $request->nama,
                'password' => ($password) ?? $user->password,
            ]);
            
            \Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $user->nama,[
                'old' => $old,
                'update' => $user->toArray()
            ]);

            DB::commit();

            return redirect(route($this->routeName . '.index'))->with(['success' => 'Berhasil Mengubah Data ' . $this->aksesMenu]);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => 'Gagal Mengubah Data ' . $this->aksesMenu . ' : ' . $e->getMessage()])->withInput($request->all());
        }
    }
    
    public function destroy(user $user)
    {
        if(!\Helper::cek_akses($this->aksesMenu,'Hapus')){
            return abort(404);
        }

        DB::beginTransaction();
        try {
            \Helper::addUserLog('Menghapus data ' .$this->aksesMenu . ' : ' . $user->nama,$user->toArray());

            $user->delete();
        
            DB::commit();
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menghapus Data user : '.$user->nama]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Menghapus Data user '.$user->nama.' : '.$e->getMessage()]);
        }
    }
}
