<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Supplier;
use Illuminate\Support\Facades\DB;
use App\Helpers\Helper;

class SupplierController extends Controller
{

    protected $routeName = 'supplier';
    protected $viewName = 'supplier';
    protected $menu = 'Master Data';
    protected $title = 'Supplier';

    protected $aksesMenu = 'Supplier';
    
    public function index()
    {
        if(!Helper::cek_akses($this->aksesMenu)){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'ubah'=>Helper::cek_akses($this->aksesMenu,'Ubah'),
            'hapus'=>Helper::cek_akses($this->aksesMenu,'Hapus')
        ];

        $datas = Supplier::all();
        
        return view($this->viewName.'.index', compact('settings', 'datas'));
    }
    
    public function create()
    {
        if(!Helper::cek_akses($this->aksesMenu, 'Tambah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=> route($this->routeName.'.store'),
        ];
        
        return view($this->viewName.'.form', compact('settings'));
    }
    
    public function store(Request $request)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Tambah')){
            return abort(404);
        }

        $request->validate([
            'nama_supplier'=>'required',
            'no_telp'=>'required',
        ]);

        DB::beginTransaction();

        try {
            $supplier = Supplier::create([
               'nama_supplier'=>$request->nama_supplier,
               'no_telp'=>$request->no_telp,
               'alamat'=>$request->alamat,
            ]);

            DB::commit();

            Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $supplier->nama_supplier,$supplier->toArray());
            
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menambah Data ' .$this->aksesMenu. ' : '.$supplier->nama_supplier]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : '.$e->getMessage()])->withInput($request->all());
        }
    }

    public function show($id)
    {
        //
    }
    
    public function edit(supplier $supplier)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=>route($this->routeName.'.update',$supplier->id),
        ];

        return view($this->viewName.'.form',compact('settings'),['data'=>$supplier]);
    }

    public function update(Request $request, supplier $supplier)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }
        
        $request->validate([
            'nama_supplier'=>'required',
            'no_telp'=>'required',
        ]);
        
        DB::beginTransaction();
        try {
            $old = $supplier->toArray();
            $supplier->update([
               'nama_supplier'=>$request->nama_supplier,
               'no_telp'=>$request->no_telp,
               'alamat'=>$request->alamat
            ]);
            DB::commit();

            Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $supplier->nama_supplier,[
                'old' => $old,
                'update' => $supplier->toArray()
            ]);

            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Mengubah Data ' .$this->aksesMenu. ' : '.$supplier->nama_supplier]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Mengubah Data ' .$this->aksesMenu. ' : '.$e->getMessage()])->withInput($request->all());
        }
    }
    
    public function destroy(supplier $supplier)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Hapus')){
            return abort(404);
        }

        DB::beginTransaction();
        try {
            Helper::addUserLog('Menghapus data ' .$this->aksesMenu . ' : ' . $supplier->nama_supplier,$supplier->toArray());

            $supplier->delete();
        
            DB::commit();
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menghapus Data supplier : '.$supplier->nama_supplier]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Menghapus Data supplier '.$supplier->nama_supplier.' : '.$e->getMessage()]);
        }
    }
}
