<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PembayaranPengeluaran;
use App\Models\DetailPengeluaran;
use App\Models\Pengeluaran;
use App\Models\JurnalUmum;
use App\Models\Akun;
use App\Helpers\Helper;
use Illuminate\Support\Facades\DB;

class PengeluaranController extends Controller
{

    protected $routeName = 'pengeluaran';
    protected $viewName = 'pengeluaran';
    protected $menu = 'Master Data';
    protected $title = 'Pengeluaran';

    protected $aksesMenu = 'Pengeluaran';
    
    public function index()
    {
        if(!Helper::cek_akses($this->aksesMenu)){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'ubah'=>Helper::cek_akses($this->aksesMenu,'Ubah'),
            'hapus'=>Helper::cek_akses($this->aksesMenu,'Hapus')
        ];

        $datas = Pengeluaran::orderBy('created_at', 'desc')->get();
        
        return view($this->viewName.'.index', compact('settings', 'datas'));
    }
    
    public function create()
    {
        if(!Helper::cek_akses($this->aksesMenu, 'Tambah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=> route($this->routeName.'.store'),
        ];

        $akuns = Akun::all();
        
        return view($this->viewName.'.form', compact('settings', 'akuns'));
    }
    
    public function store(Request $request)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Tambah')){
            return abort(404);
        }

        $request->validate([
            'akun_id'=>'required',
            'tgl_pengeluaran'=>'required',
            'tgl_jatuh_tempo'=>'required',
        ]);

        DB::beginTransaction();

        try {
            if(count($request->akun_id) <= 0)
                return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : Masukkan Setidaknya Satu Akun'])->withInput($request->all());

            $pengeluaran = Pengeluaran::create([
                'tgl_pengeluaran'=>$request->tgl_pengeluaran,
                'tgl_jatuh_tempo'=>$request->tgl_jatuh_tempo,
                'no_pengeluaran'=> Helper::generateNoPengeluaran(),
                'catatan'=>$request->catatan,
            ]);

            $total = 0;
            $hpp = 0;
            $totalDiskon = 0;
            $totalPajak = 0;
            $totalPendapatan = 0;
            $totalPiutang = 0;

            for ($i=0; $i < count($request->akun_id); $i++) { 
                $akunBeban = Akun::find($request->akun_id[$i]);

                if(!$akunBeban)
                    return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : akun Dengan Id ' . $request->akun_id[$i] . 'Tidak Ditemukan'])->withInput($request->all());

                $diskon = 0;
                if ($request->tipe_diskon == 'rp') {
                    $diskon = $request->diskon[$i] ? Helper::onlyNumber($request->diskon[$i]) : 0;
                }elseif($request->tipe_diskon == 'persen'){
                    $harga = Helper::onlyNumber($request->biaya[$i]);
                    $diskon = $request->diskon[$i] ? $harga * Helper::onlyNumber($request->diskon[$i]) / 100 : 0;
                }


                $subTotal = Helper::onlyNumber($request->biaya[$i]) - $diskon;
                
                $pajak = 0;
                if($request->pajak[$i]){
                    $pajak = ($subTotal * Helper::onlyNumber($request->pajak[$i]) / 100 );
                    $subTotal =  $subTotal + $pajak;
                }else if($request->pajak_lain[$i]) {
                    $pajak = ($subTotal * Helper::onlyNumber($request->pajak_lain[$i]) / 100 );
                    $subTotal=  $subTotal + $pajak;
                }
                
                $total += $subTotal;
                $totalDiskon += $diskon;
                $totalPajak += $pajak;

                $detail = DetailPengeluaran::create([
                    'pengeluaran_id' => $pengeluaran->id,
                    'akun_id' => $request->akun_id[$i],
                    'desc' => $request->desc[$i],
                    'biaya' => Helper::onlyNumber($request->biaya[$i]),
                    'diskon' => $diskon,
                    'pajak' => ($request->pajak[$i]) ? Helper::onlyNumber($request->pajak[$i]) : null,
                    'pajak_lain' => ($request->pajak_lain[$i]) ? Helper::onlyNumber($request->pajak_lain[$i]) : null,
                ]);

                
                
                // Debet ke Akun Beban Yang Dipilih
                JurnalUmum::create([
                    'akun_id' => $akunBeban->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => Helper::onlyNumber($request->biaya[$i]),
                ]);
            }

            if(!$total)
                return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : Error, Total Gagal Dihitung '])->withInput($request->all());   
            $status = 'pending';

            $pemotongan = 0;
            if ($request->pemotongan && $request->akun_pemotongan) {
                if ($request->tipe_pemotongan == 'rp') {
                    $pemotongan = Helper::onlyNumber($request->pemotongan);
                }else if($request->tipe_pemotongan == 'persen'){
                    $pemotongan = $total * Helper::onlyNumber($request->pemotongan) / 100;
                }
            }

            $pengeluaran->update([
                'total' => $total - $pemotongan,
                'status' => $status,
                'pemotongan_akun_id' => $request->akun_pemotongan ?? NULL,
            ]);

            if ($request->pemotongan && $request->akun_pemotongan) {
                $pengeluaran->update([
                    'pemotongan' => $pemotongan,
                ]);
            }

            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();
            $akunDiskon = Akun::where('nama_akun', 'Diskon Penjualan')->first();
            $akunPajak = Akun::where('nama_akun', 'PPN Keluaran')->first();
            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();

            if ($request->pemotongan && $request->akun_pemotongan) {
                $akunPemotongan = Akun::find($request->akun_pemotongan);

                // Debet ke Akun Pemotongan
                JurnalUmum::create([
                    'akun_id' => $akunPemotongan->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => $pemotongan,
                    'description' => 'Pemotongan Produk'
                ]);
            }

            if ($totalDiskon > 0) {
                // Debet ke Akun Diskon
                JurnalUmum::create([
                    'akun_id' => $akunDiskon->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => $totalDiskon,
                ]);
            }

            if ($totalPajak > 0) {
                // Kredit ke Akun PPN
                JurnalUmum::create([
                    'akun_id' => $akunPajak->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'kredit' => $totalPajak,
                ]);
            }
            // Kredit ke Akun Hutang
            JurnalUmum::create([
                'akun_id' => $akunHutang->id,
                'tanggal' => $request->tgl_pengeluaran,
                'pengeluaran_id' => $pengeluaran->id,
                'kredit' => $total - $pemotongan,
            ]);

            DB::commit();

            Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $pengeluaran->no_pengeluaran,$pengeluaran->toArray());
            
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menambah Data ' .$this->aksesMenu. ' : '.$pengeluaran->no_pengeluaran]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : '.$e->getMessage()])->withInput($request->all());
        }
    }

    public function show(pengeluaran $pengeluaran)
    {
        if(!Helper::cek_akses($this->aksesMenu)){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=>route($this->routeName.'.bayar',$pengeluaran->id),
        ];

        $akuns = Akun::all();

        return view($this->viewName.'.show',compact('settings', 'akuns'),['data'=>$pengeluaran]);
    }
    
    public function edit(pengeluaran $pengeluaran)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=>route($this->routeName.'.update',$pengeluaran->id),
        ];
        $akuns = Akun::all();

        return view($this->viewName.'.form',compact('settings', 'akuns'),['data'=>$pengeluaran]);
    }

    public function update(Request $request, pengeluaran $pengeluaran)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }
        
        $request->validate([
            'akun_id'=>'required',
            'tgl_pengeluaran'=>'required',
            'tgl_jatuh_tempo'=>'required',
        ]);
        
        DB::beginTransaction();
        try {
            $old = $pengeluaran->toArray();
            
            $pengeluaran->update([
                'tgl_pengeluaran'=>$request->tgl_pengeluaran,
                'tgl_jatuh_tempo'=>$request->tgl_jatuh_tempo,
                'catatan'=>$request->catatan,
            ]);
            
            $total = 0;
            $hpp = 0;
            $totalDiskon = 0;
            $totalPajak = 0;
            $totalPendapatan = 0;
            $totalPiutang = 0;
            $pengeluaran->detail()->delete();
            $pengeluaran->JurnalUmum()->delete();
             for ($i=0; $i < count($request->akun_id); $i++) { 
                $akun = Akun::find($request->akun_id[$i]);

                if(!$akun)
                    return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : akun Dengan Id ' . $request->akun_id[$i] . 'Tidak Ditemukan'])->withInput($request->all());

                    $diskon = 0;
                    if ($request->tipe_diskon == 'rp') {
                        $diskon = $request->diskon[$i] ? Helper::onlyNumber($request->diskon[$i]) : 0;
                    }elseif($request->tipe_diskon == 'persen'){
                        $harga = Helper::onlyNumber($request->biaya[$i]);
                        $diskon = $request->diskon[$i] ? $harga * Helper::onlyNumber($request->diskon[$i]) / 100 : 0;
                    }

                $subtotal = Helper::onlyNumber($request->biaya[$i]) - $diskon;
                
                $pajak = 0;
                if($request->pajak[$i]){
                    $pajak = ($subtotal * Helper::onlyNumber($request->pajak[$i]) / 100 );
                    $subtotal =  $subtotal + $pajak;
                }else if($request->pajak_lain[$i]) {
                    $pajak = ($subtotal * Helper::onlyNumber($request->pajak_lain[$i]) / 100 );
                    $subtotal=  $subtotal + $pajak;
                }

                $total += $subtotal;
                $totalDiskon += $diskon;
                $totalPajak += $pajak;

                $detail = DetailPengeluaran::create([
                    'pengeluaran_id' => $pengeluaran->id,
                    'akun_id' => $request->akun_id[$i],
                    'desc' => $request->desc[$i],
                    'biaya' => Helper::onlyNumber($request->biaya[$i]),
                    'diskon' => $diskon,
                    'pajak' => ($request->pajak[$i]) ? Helper::onlyNumber($request->pajak[$i]) : null,
                    'pajak_lain' => ($request->pajak_lain[$i]) ? Helper::onlyNumber($request->pajak_lain[$i]) : null,
                ]);

                // Debet ke Akun Beban Yang Dipilih
                JurnalUmum::create([
                    'akun_id' => $akun->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => Helper::onlyNumber($request->biaya[$i]) - $diskon,
                ]);

            }

            if(!$total)
                return redirect()->back()->with(['error'=>'Gagal Menambah Data ' .$this->aksesMenu. ' : Error, Total Gagal Dihitung '])->withInput($request->all());


                $pemotongan = 0;
                if ($request->pemotongan && $request->akun_pemotongan) {
                    if ($request->tipe_pemotongan == 'rp') {
                        $pemotongan = Helper::onlyNumber($request->pemotongan);
                    }else if($request->tipe_pemotongan == 'persen'){
                        $pemotongan = $total * Helper::onlyNumber($request->pemotongan) / 100;
                    }
                }
    
                $pengeluaran->update([
                    'total' => $total - $pemotongan,
                    'pemotongan_akun_id' => $request->akun_pemotongan ?? NULL,
                ]);
    
                if ($request->pemotongan && $request->akun_pemotongan) {
                    $pengeluaran->update([
                        'pemotongan' => $pemotongan,
                    ]);
                }
                

            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();
            $akunDiskon = Akun::where('nama_akun', 'Diskon Penjualan')->first();
            $akunPajak = Akun::where('nama_akun', 'PPN Keluaran')->first();
            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();

            if ($request->pemotongan && $request->akun_pemotongan) {
                $akunPemotongan = Akun::find($request->akun_pemotongan);

                // Debet ke Akun Pemotongan
                JurnalUmum::create([
                    'akun_id' => $akunPemotongan->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => $pemotongan,
                    'description' => 'Pemotongan Produk'
                ]);
            }

            if ($totalDiskon > 0) {
                // Debet ke Akun Diskon
                JurnalUmum::create([
                    'akun_id' => $akunDiskon->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'debet' => $totalDiskon,
                ]);
            }

            if ($totalPajak > 0) {
                // Kredit ke Akun PPN
                JurnalUmum::create([
                    'akun_id' => $akunPajak->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'pelanggan_id' => $request->pelanggan_id,
                    'pengeluaran_id' => $pengeluaran->id,
                    'kredit' => $totalPajak,
                ]);
            }
            // Kredit ke Akun Hutang
            JurnalUmum::create([
                'akun_id' => $akunHutang->id,
                'tanggal' => $request->tgl_pengeluaran,
                'pengeluaran_id' => $pengeluaran->id,
                'kredit' => $total - $pemotongan,
            ]);

            DB::commit();

            Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' : ' . $pengeluaran->no_pengeluaran,[
                'old' => $old,
                'update' => $pengeluaran->toArray()
            ]);

            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Mengubah Data ' .$this->aksesMenu. ' : '.$pengeluaran->no_pengeluaran]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Mengubah Data ' .$this->aksesMenu. ' : '.$e->getMessage()])->withInput($request->all());
        }
    }

    public function bayar(Request $request, $id)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Tambah')){
            return abort(404);
        }
        
        $request->validate([
            'akun_id'=>'required',
            'tgl_bayar'=>'required',
            'jumlah_bayar'=>'required',
        ]);
        
        DB::beginTransaction();
        try {
            $pengeluaran = Pengeluaran::find($id);
            
            $pembayaran_pengeluaran = PembayaranPengeluaran::create([
                'akun_id'=>$request->akun_id,
                'pengeluaran_id' => $pengeluaran->id,
                'tgl_bayar' => $request->tgl_bayar,
                'jumlah_bayar' => Helper::onlyNumber($request->jumlah_bayar),
            ]);

            if($pengeluaran->sisaTagihan > 0){
                $status = 'pending';
            }elseif($pengeluaran->sisaTagihan <= 0){
                $status = 'paid';
            }

            $pengeluaran->update([
                'status' => $status,
            ]);
            
            $akunKas = Akun::find($request->akun_id);
            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();
            // Debet ke Akun Hutang
            JurnalUmum::create([
                'akun_id' => $akunHutang->id,
                'tanggal' => $request->tgl_bayar,
                'pembayaran_pengeluaran_id' => $pembayaran_pengeluaran->id,
                'debet' => Helper::onlyNumber($request->jumlah_bayar),
            ]);

            // Kredit ke Akun Kas (Yang Dipilih)
            JurnalUmum::create([
                'akun_id' => $akunKas->id,
                'tanggal' => $request->tgl_bayar,
                'pembayaran_pengeluaran_id' => $pembayaran_pengeluaran->id,
                'kredit' => Helper::onlyNumber($request->jumlah_bayar),
            ]);

            DB::commit();

            Helper::addUserLog('Menambah data ' .$this->aksesMenu . ' Pembayaran : ' . $pengeluaran->no_pengeluaran,$pengeluaran->toArray());

            return redirect(route($this->routeName.'.show', $id))->with(['success'=>'Berhasil Menambah Data ' .$this->aksesMenu. ' Pembayaran: '.$pengeluaran->no_pengeluaran]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Mengubah Data ' .$this->aksesMenu. ' Pembayaran : '.$e->getMessage()])->withInput($request->all());
        }
    }

    public function update_detail(Request $request)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Ubah')){
            return abort(404);
        }

        DB::beginTransaction();
        try {
            
            $pembayaran_pengeluaran = PembayaranPengeluaran::find($request->id);

            $pembayaran_pengeluaran->update([
                'jumlah_bayar' => $request->harga
            ]);

            $akunKas = Akun::find($pembayaran_pengeluaran->akun_id);
            $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->first();

            $jurnalUmumKas = JurnalUmum::where('pembayaran_pengeluaran_id', $pembayaran_pengeluaran->id)->where('akun_id', $akunKas->id)->first();

            $jurnalUmumHutang = JurnalUmum::where('pembayaran_pengeluaran_id', $pembayaran_pengeluaran->id)->where('akun_id', $akunHutang->id)->first();

            // Debet ke Akun Hutang
            $jurnalUmumHutang->update([
                'debet' => Helper::onlyNumber($request->harga),
            ]);

            // Kredit ke Akun Kas
            $jurnalUmumKas->update([
                'kredit' => Helper::onlyNumber($request->harga),
            ]);



            DB::commit();
            $data = [
                'status' => 200,
            ];
        } catch (\Exception $e) {
            DB::rollBack();
            $data = [
                'status' => 500,
                'message' => 'Tidak Dapat diubah ' .$e->getMessage(),
                'data' => null,
            ];
        }
        return response()->json($data,$data['status']);
    }
    
    public function destroy(pengeluaran $pengeluaran)
    {
        if(!Helper::cek_akses($this->aksesMenu,'Hapus')){
            return abort(404);
        }

        DB::beginTransaction();
        try {
            Helper::addUserLog('Menghapus data ' .$this->aksesMenu . ' : ' . $pengeluaran->no_pengeluaran,$pengeluaran->toArray());

            foreach ($pengeluaran->pembayaran as $pembayaran) {
                $pembayaran->delete();
            }
            $pengeluaran->delete();
        
            DB::commit();
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menghapus Data pengeluaran : '.$pengeluaran->no_pengeluaran]);
        } catch (\Exception $e){
            DB::rollBack();
            return redirect()->back()->with(['error'=>'Gagal Menghapus Data pengeluaran '.$pengeluaran->no_pengeluaran.' : '.$e->getMessage()]);
        }
    }
}
