<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Akun;
use App\Models\Penjualan;
use App\Models\Produk;
use App\Models\Pembelian;
use App\Models\DetailPengeluaran;
use App\Models\DetailPenjualan;
use App\Helpers\Helper;
use App\Models\JurnalUmum;
use Carbon\Carbon;

class LaporanController extends Controller
{
    protected $routeName = 'laporan';
    protected $viewName = 'laporan';
    protected $menu = 'Laporan';
    protected $title = 'Laporan';

    public function index()
    {
        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
        ];

        return view($this->viewName.'.index', compact('settings'));
    }

    public function laba_rugi(Request $request)
    {   

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title . ' Laba Rugi',
            'route' => $this->routeName,
        ];

        $tgl_mulai = $request->get('tgl_mulai', date('Y-m-01'));
        $tgl_selesai = $request->get('tgl_selesai', date("Y-m-t"));
        $periode = $request->get('periode', 'tanggal');
        $bandingkan_periode = $request->get('bandingkan_periode', null);

        $akunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunDiskon = Akun::where('nama_akun', 'Diskon Penjualan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();

        // Cari Kredit Akun Pendapatan
        $kreditAkunPendapatan = 0;
        foreach($akunPendapatan->jurnal as $jurnal){
            $kreditAkunPendapatan += $jurnal->kredit;
        }

        // Cari Debet Akun Diskon
        $debetAkunDiskon = 0;
        foreach($akunDiskon->jurnal as $jurnal){
            $debetAkunDiskon += $jurnal->debet;
        }

        // Cari Debet Akun HPP
        $debetAkunHpp = 0;
        foreach($akunHpp->jurnal as $jurnal){
            $debetAkunHpp += $jurnal->debet;
        }

        // Cari Debet Akun Beban
        $debetAkunBeban = 0;
        foreach ($akunBeban as $beban) {
            $debetAkunBeban += $beban->debet;
        }

        // Cek Jika Ada Perbandingan Periode
        $arr_bandingkan_periode = [];
        $periode_tgl_mulai = $tgl_mulai;
        $periode_tgl_selesai = $tgl_selesai;
        if ($bandingkan_periode) {

            // Perulangan Periode
            for ($i=0; $i < $bandingkan_periode; $i++) { 
                $between = date_diff(date_create($periode_tgl_mulai), date_create($periode_tgl_selesai));

                $periode_tgl_mulai = date('Y-m-d',(strtotime ( '-'. $between->d -1 . ' day' , strtotime ( $periode_tgl_mulai) ) ));

                $periode_tgl_selesai = date('Y-m-d',(strtotime ( '-'. $between->d - 1 . ' day' , strtotime ( $periode_tgl_selesai) ) ));

                $periodeAkunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunDiskon = Akun::where('nama_akun', 'Diskon Penjualan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();
        
                // Cari Kredit Akun Pendapatan
                $periodeKreditAkunPendapatan = 0;
                foreach($periodeAkunPendapatan->jurnal as $jurnal){
                    $periodeKreditAkunPendapatan += $jurnal->kredit;
                }

                // Cari Debet Akun Diskon
                $periodeDebetAkunDiskon = 0;
                foreach($periodeAkunDiskon->jurnal as $jurnal){
                    $periodeDebetAkunDiskon += $jurnal->debet;
                }
        
                // Cari Debet Akun HPP
                $periodeDebetAkunHpp = 0;
                foreach($periodeAkunHpp->jurnal as $jurnal){
                    $periodeDebetAkunHpp += $jurnal->debet;
                }
        
                // Cari Debet Akun Beban
                $periodeDebetAkunBeban = 0;
                foreach ($periodeAkunBeban as $beban) {
                    $periodeDebetAkunBeban += $beban->debet;
                }

                $arr_bandingkan_periode[] = [
                    'tgl_mulai' => $periode_tgl_mulai,
                    'tgl_selesai' => $periode_tgl_selesai,
                    'kredit_akun_pendapatan' => $periodeKreditAkunPendapatan,
                    'debet_akun_hpp' => $periodeDebetAkunHpp,
                    'debet_akun_beban' => $periodeDebetAkunBeban,
                    'debet_akun_diskon' => $periodeDebetAkunDiskon,
                ];
            }
        }

        return view($this->viewName.'.laba_rugi', compact('settings','akunPendapatan', 'akunDiskon', 'akunHpp', 'akunBeban','request', 'tgl_mulai', 'tgl_selesai', 'periode', 'bandingkan_periode', 'kreditAkunPendapatan', 'debetAkunDiskon', 'debetAkunHpp', 'debetAkunBeban', 'arr_bandingkan_periode'));
    }

    public function arus_kas(Request $request)
    {
        $settings = [
            'menu' => $this->menu,
            'title' => $this->title . ' Arus Kas',
            'route' => $this->routeName,
        ];

        $tgl_mulai = $request->get('tgl_mulai', date('Y-m-01'));
        $tgl_selesai = $request->get('tgl_selesai', date("Y-m-t"));
        $periode = $request->get('periode', 'tanggal');
        $bandingkan_periode = $request->get('bandingkan_periode', null);

        $akunPersediaan = Akun::where('nama_akun', 'Akun Persediaan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunPiutang = Akun::where('nama_akun', 'Akun Piutang')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();

        // Cari Kredit Akun Persediaan
        $debetAkunPersediaan = 0;
        foreach($akunPersediaan->jurnal as $jurnal){
            $debetAkunPersediaan += $jurnal->debet;
        }

        // Cari Kredit Akun Piutang
        $kreditAkunPiutang = 0;
        foreach($akunPiutang->jurnal as $jurnal){
            $kreditAkunPiutang += $jurnal->kredit;
        }

        // Cari Debet Akun HPP
        $debetAkunHpp = 0;
        foreach($akunHpp->jurnal as $jurnal){
            $debetAkunHpp += $jurnal->debet;
        }

        // Cari Debet Akun Beban
        $debetAkunBeban = 0;
        foreach ($akunBeban as $beban) {
            $debetAkunBeban += $beban->debet;
        }

        // Cek Jika Ada Perbandingan Periode
        $arr_bandingkan_periode = [];
        $periode_tgl_mulai = $tgl_mulai;
        $periode_tgl_selesai = $tgl_selesai;
        if ($bandingkan_periode) {

            // Perulangan Periode
            for ($i=0; $i < $bandingkan_periode; $i++) { 
                $between = date_diff(date_create($periode_tgl_mulai), date_create($periode_tgl_selesai));

                $periode_tgl_mulai = date('Y-m-d',(strtotime ( '-'. $between->d -1 . ' day' , strtotime ( $periode_tgl_mulai) ) ));

                $periode_tgl_selesai = date('Y-m-d',(strtotime ( '-'. $between->d - 1 . ' day' , strtotime ( $periode_tgl_selesai) ) ));

                $periodeAkunPersediaan = Akun::where('nama_akun', 'Akun Persediaan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunPiutang = Akun::where('nama_akun', 'Akun Piutang')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();

                // Cari Kredit Akun Persediaan
                $periodeDebetAkunPersediaan = 0;
                foreach($periodeAkunPersediaan->jurnal as $jurnal){
                    $periodeDebetAkunPersediaan += $jurnal->debet;
                }

                // Cari Kredit Akun Piutang
                $periodeKreditAkunPiutang = 0;
                foreach($periodeAkunPiutang->jurnal as $jurnal){
                    $periodeKreditAkunPiutang += $jurnal->kredit;
                }
        
                // Cari Debet Akun HPP
                $periodeDebetAkunHpp = 0;
                foreach($periodeAkunHpp->jurnal as $jurnal){
                    $periodeDebetAkunHpp += $jurnal->debet;
                }
        
                // Cari Debet Akun Beban
                $periodeDebetAkunBeban = 0;
                foreach ($periodeAkunBeban as $beban) {
                    $periodeDebetAkunBeban += $beban->debet;
                }

                $arr_bandingkan_periode[] = [
                    'tgl_mulai' => $periode_tgl_mulai,
                    'tgl_selesai' => $periode_tgl_selesai,
                    'debet_akun_persediaan' => $periodeDebetAkunPersediaan,
                    'kredit_akun_piutang' => $periodeKreditAkunPiutang,
                    'debet_akun_hpp' => $periodeDebetAkunHpp,
                    'debet_akun_beban' => $periodeDebetAkunBeban,
                ];
            }
        }

        // Ambil Jurnal Akun Kas
        $saldoAkunKas = JurnalUmum::where('opening_akun', 'yes')->where('akun_id', 1)->first();
        $saldoKasAwal = 0;

        if($saldoAkunKas){
            $saldoKasAwal = $saldoAkunKas->debet ?? 0;
        }

        return view($this->viewName.'.arus_kas', compact('settings', 'akunPersediaan', 'akunHpp', 'akunBeban', 'akunPiutang', 'saldoKasAwal','request', 'debetAkunPersediaan', 'kreditAkunPiutang', 'debetAkunHpp', 'debetAkunBeban', 'tgl_mulai', 'tgl_selesai', 'periode', 'bandingkan_periode', 'arr_bandingkan_periode'));
    }

    public function neraca(Request $request)
    {
        $settings = [
            'menu' => $this->menu,
            'title' => $this->title . ' Neraca',
            'route' => $this->routeName,
        ];

        $tgl_mulai = $request->get('tgl_mulai', date('Y-m-01'));
        $tgl_selesai = $request->get('tgl_selesai', date("Y-m-t"));
        $periode = $request->get('periode', 'tanggal');
        $bandingkan_periode = $request->get('bandingkan_periode', null);

        $akunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunPersediaan = Akun::where('nama_akun', 'Akun Persediaan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        // $akunEkuitas = Akun::where('nama_akun', 'Pembukaan Saldo Ekuitas')->first();

        $akunPiutang = Akun::where('nama_akun', 'Akun Piutang')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunHutang = Akun::where('nama_akun', 'Akun Hutang')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunPpn = Akun::where('nama_akun', 'PPN Keluaran')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunKas = Akun::whereHas('kategori', function($kategori){
            $kategori->where('nama_kategori', 'Cash & Bank');
        })->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();
        
        $akunBeban = Akun::whereHas('kategori', function($kategori){
            $kategori->where('nama_kategori', 'Beban');
        })->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();
        
        $akunBeban1 = Akun::whereHas('kategori', function($kategori){
            $kategori->Where('nama_kategori', 'Hutang Usaha');
        })->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();
        
        $akunEkuitas = Akun::whereHas('kategori', function($kategori){
            $kategori->where('nama_kategori', 'Pembukaan Saldo Ekuitas');
        })->where('nama_akun', '!=', 'Laba Ditahan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();
        
        $akunEkuitasAll = Akun::whereHas('kategori', function($kategori){
            $kategori->where('nama_kategori', 'Pembukaan Saldo Ekuitas');
        })->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();

        $akunPemotongan = Akun::whereHas('jurnal', function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai])->where('description', 'Pemotongan Produk');
        })->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai])->where('description', 'Pemotongan Produk');
        }])->get();
        
        $akunAset = $akunKas->merge($akunPemotongan);

        // Hitung Total Aset
        // Akun Kas + piutang + persediaan
        $total_aset = 0;
        $total_liabilitas = 0;
        $total_liabilitas1 = 0;
        $modal_awal = 0;
        foreach ($akunAset as $aset) {
            $total_aset += $aset->saldo;
        }
        foreach ($akunEkuitas as $modal) {
            $modal_awal += $modal->kredit;
        }
        foreach ($akunBeban as $beban) {
            $total_liabilitas += $beban->debet;
        }
        foreach ($akunBeban1 as $beban) {
            $total_liabilitas1 += $beban->saldo;
        }
        $total_aset += $akunPiutang->saldo;
        $total_aset += @$akunPersediaan->jurnal->last()->balance;
        
        $laba_ditahan = Akun::where('nama_akun', "Laba Ditahan")->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        // Cari Balance Akun Persediaan
        $balanceAkunPersediaan = @$akunPersediaan->jurnal->last()->balance;
        
        // Cari Debet Akun Ekuitas
        // $debetAkunEkuitas = @$akunEkuitas->kredit;

        // Cari Kredit Akun Piutang
        $kreditAkunPiutang = @$akunPiutang->saldo;

        // Cari Kredit Akun PPN
        $kreditAkunPpn = @$akunPpn->kredit;
        $total_liabilitas1 += $kreditAkunPpn;
        
        // Cari Balance Akun Hutang
        $balanceAkunHutang = @$akunHutang->jurnal->last()->balance;

        // Cari Pendapatan Bersih, (Pendapatan Kredit - Hpp Debet)
        $pendapatanBersih = @$akunPendapatan->kredit - @$akunHpp->debet;
        
        $akunLabaDitahan = Akun::where('nama_akun', 'Laba Ditahan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();
        if($akunLabaDitahan->kredit != $total_liabilitas - $pendapatanBersih){
            JurnalUmum::create([
                    'akun_id' => $laba_ditahan->id,
                    'tanggal' => $tgl_mulai?$tgl_mulai:Carbon::now()->format("Y-m-d"),
                    'kredit' => $total_liabilitas - $pendapatanBersih,
                ]);
        }

        // Hitung Modal Pemilik
        $total_modal = $modal_awal - ($total_liabilitas - $pendapatanBersih);
        // Cek Jika Ada Perbandingan Periode
        $arr_bandingkan_periode = [];
        $periode_tgl_mulai = $tgl_mulai;
        $periode_tgl_selesai = $tgl_selesai;
        if ($bandingkan_periode) {

            // Perulangan Periode
            for ($i=0; $i < $bandingkan_periode; $i++) { 
                $between = date_diff(date_create($periode_tgl_mulai), date_create($periode_tgl_selesai));

                $periode_tgl_mulai = date('Y-m-d',(strtotime ( '-'. $between->d -1 . ' day' , strtotime ( $periode_tgl_mulai) ) ));

                $periode_tgl_selesai = date('Y-m-d',(strtotime ( '-'. $between->d - 1 . ' day' , strtotime ( $periode_tgl_selesai) ) ));

                $periodeAkunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunPersediaan = Akun::where('nama_akun', 'Akun Persediaan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunHutang = Akun::where('nama_akun', 'Akun Hutang')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunPpn = Akun::where('nama_akun', 'PPN Keluaran')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunPiutang = Akun::where('nama_akun', 'Akun Piutang')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();

                $periodeAkunKas = Akun::whereHas('kategori', function($kategori){
                    $kategori->where('nama_kategori', 'Cash & Bank');
                })->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();

                $periodeAkunEkuitas = Akun::whereHas('kategori', function($kategori){
                    $kategori->where('nama_kategori', 'Pembukaan Saldo Ekuitas');
                })->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();

                $periodeAkunBeban = Akun::whereHas('kategori', function($kategori){
                    $kategori->where('nama_kategori', 'Beban');
                })->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();
                
                $periodeAkunBeban1 = Akun::whereHas('kategori', function($kategori){
                    $kategori->where('nama_kategori', 'Hutang Usaha');
                })->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();

                $periodeAkunPemotongan = Akun::whereHas('jurnal', function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai])->where('description', 'Pemotongan Produk');
                })->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai])->where('description', 'Pemotongan Produk');
                }])->get();
                
                $periodeAkunAset = $periodeAkunKas->merge($periodeAkunPemotongan);

                // Hitung Total Aset
                // Akun Kas + piutang + persediaan
                $periode_total_aset = 0;
                $periode_total_liabilitas = 0;
                $periode_total_liabilitas1 = 0;
                $periode_modal_awal = 0;
                foreach ($periodeAkunAset as $aset) {
                    $periode_total_aset += $aset->saldo;
                }
                foreach ($periodeAkunBeban as $beban) {
                    $periode_total_liabilitas += $beban->debet;
                }
                foreach ($periodeAkunBeban1 as $beban) {
                    $periode_total_liabilitas1 += $beban->saldo;
                }
                foreach ($periodeAkunEkuitas as $modal) {
                    $periode_modal_awal += $modal->kredit;
                }
                $periode_total_aset += @$periodeAkunPiutang->kredit;
                $periode_total_aset += @$periodeAkunPersediaan->jurnal->last()->balance;

                // Cari Balance Akun Persediaan
                $periodeBalanceAkunPersediaan = @$periodeAkunPersediaan->jurnal->last()->balance;

                // Cari Balance Akun Hutang
                $periodeBalanceAkunHutang = @$periodeAkunHutang->jurnal->last()->balance;

                // Cari Pendapatan Bersih, (Pendapatan Kredit - HPP Debet)
                $periodePendapatanBersih = @$periodeAkunPendapatan->kredit - @$periodeAkunHpp->debet;

                // Cari Kredit Akun Ppn
                $periodeKreditAkunPpn = @$periodeAkunPpn->kredit;

                // Cari Kredit Akun Piutang
                $periodeKreditAkunPiutang = @$periodeAkunPiutang->saldo;

                // Hitung Modal Pemilik
                $periode_total_modal = ($periode_modal_awal - $periode_total_liabilitas) + $periodePendapatanBersih;

                $arr_bandingkan_periode[] = [
                    'tgl_mulai' => $periode_tgl_mulai,
                    'tgl_selesai' => $periode_tgl_selesai,
                    'balance_akun_persediaan' => $periodeBalanceAkunPersediaan,
                    'balance_akun_hutang' => $periodeBalanceAkunHutang,
                    'kredit_akun_piutang' => $periodeKreditAkunPiutang,
                    'kredit_akun_ppn' => $periodeKreditAkunPpn,
                    'periode_akun_kas' => $periodeAkunKas,
                    'periode_akun_ekuitas' => $periodeAkunEkuitas,
                    'periode_akun_beban' => $periodeAkunBeban,
                    'periode_akun_beban1' => $periodeAkunBeban1,
                    'periode_akun_aset' => $periodeAkunAset,
                    'pendapatan_bersih' => $periodePendapatanBersih,
                    'total_aset' => $periode_total_aset,
                    'total_modal' => $periode_total_modal,
                ];
            }
        }

        return view($this->viewName.'.neraca', compact('settings', 'akunPersediaan', 'akunEkuitas', 'akunHutang', 'akunAset', 'akunPiutang', 'akunPpn', 'request', 'balanceAkunPersediaan', 'balanceAkunHutang', 'pendapatanBersih', 'total_modal', 'kreditAkunPiutang', 'kreditAkunPpn', 'tgl_mulai', 'tgl_selesai', 'periode', 'bandingkan_periode', 'arr_bandingkan_periode', 'total_aset', 'akunBeban', 'total_liabilitas', 'modal_awal', 'akunEkuitasAll', 'akunBeban1', 'total_liabilitas1'));
    }

    public function perubahan_modal(Request $request)
    {
        $settings = [
            'menu' => $this->menu,
            'title' => $this->title . ' Perubahan Modal',
            'route' => $this->routeName,
        ];

        $tgl_mulai = $request->get('tgl_mulai', date('Y-m-01'));
        $tgl_selesai = $request->get('tgl_selesai', date("Y-m-t"));
        $periode = $request->get('periode', 'tanggal');
        $bandingkan_periode = $request->get('bandingkan_periode', null);

        $akunEkuitas = Akun::where('nama_akun', 'Pembukaan Saldo Ekuitas')->first();

        $akunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->first();

        $akunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($tgl_mulai, $tgl_selesai){
            $jurnal->whereBetween('tanggal', [$tgl_mulai, $tgl_selesai]);
        }])->get();

        // Cari Kredit Akun Pendapatan
        $kreditAkunPendapatan = 0;
        foreach($akunPendapatan->jurnal as $jurnal){
            $kreditAkunPendapatan += $jurnal->kredit;
        }

        // Cari Debet Akun HPP
        $debetAkunHpp = 0;
        foreach($akunHpp->jurnal as $jurnal){
            $debetAkunHpp += $jurnal->debet;
        }

        // Cari Debet Akun Beban
        $debetAkunBeban = 0;
        foreach ($akunBeban as $beban) {
            $debetAkunBeban += $beban->debet;
        }

        // Cari Debet Akun Ekuitas
        $debetAkunEkuitas = @$akunEkuitas->kredit;

        // Hitung Modal Pemilik
        $laba_rugi = abs(($kreditAkunPendapatan - $debetAkunHpp) - $debetAkunBeban);
        $total_modal = $debetAkunEkuitas - $laba_rugi;

        // Cek Jika Ada Perbandingan Periode
        $arr_bandingkan_periode = [];
        $periode_tgl_mulai = $tgl_mulai;
        $periode_tgl_selesai = $tgl_selesai;
        if ($bandingkan_periode) {
            // Perulangan Periode
            for ($i=0; $i < $bandingkan_periode; $i++) { 
                $between = date_diff(date_create($periode_tgl_mulai), date_create($periode_tgl_selesai));

                $periode_tgl_mulai = date('Y-m-d',(strtotime ( '-'. $between->d -1 . ' day' , strtotime ( $periode_tgl_mulai) ) ));

                $periode_tgl_selesai = date('Y-m-d',(strtotime ( '-'. $between->d - 1 . ' day' , strtotime ( $periode_tgl_selesai) ) ));

                $periodeAkunPendapatan = Akun::where('nama_akun', 'Akun Pendapatan')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunHpp = Akun::where('nama_akun', 'Biaya Penjualan (HPP)')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->first();
        
                $periodeAkunBeban = Akun::where('kategori_akun_id', '6')->with(['jurnal' => function($jurnal) use($periode_tgl_mulai, $periode_tgl_selesai){
                    $jurnal->whereBetween('tanggal', [$periode_tgl_mulai, $periode_tgl_selesai]);
                }])->get();
        
                // Cari Kredit Akun Pendapatan
                $periodeKreditAkunPendapatan = 0;
                foreach($periodeAkunPendapatan->jurnal as $jurnal){
                    $periodeKreditAkunPendapatan += $jurnal->kredit;
                }
        
                // Cari Debet Akun HPP
                $periodeDebetAkunHpp = 0;
                foreach($periodeAkunHpp->jurnal as $jurnal){
                    $periodeDebetAkunHpp += $jurnal->debet;
                }
        
                // Cari Debet Akun Beban
                $periodeDebetAkunBeban = 0;
                foreach ($periodeAkunBeban as $beban) {
                    $periodeDebetAkunBeban += $beban->debet;
                }

                $periode_laba_rugi = abs(($periodeKreditAkunPendapatan - $periodeDebetAkunHpp) - $periodeDebetAkunBeban);

                // Hitung Modal Pemilik
                $periode_total_modal = $debetAkunEkuitas - $periode_laba_rugi;
                
                $arr_bandingkan_periode[] = [
                    'tgl_mulai' => $periode_tgl_mulai,
                    'tgl_selesai' => $periode_tgl_selesai,
                    'kredit_akun_pendapatan' => $periodeKreditAkunPendapatan,
                    'debet_akun_hpp' => $periodeDebetAkunHpp,
                    'debet_akun_beban' => $periodeDebetAkunBeban,
                    'laba_rugi' => $periode_laba_rugi,
                    'total_modal' => $periode_total_modal,
                ];
            }
        }

        return view($this->viewName.'.perubahan_modal', compact('settings','akunPendapatan', 'akunHpp', 'akunBeban', 'akunEkuitas', 'debetAkunEkuitas','request', 'tgl_mulai', 'tgl_selesai', 'kreditAkunPendapatan', 'debetAkunHpp', 'debetAkunBeban', 'periode', 'bandingkan_periode', 'arr_bandingkan_periode', 'total_modal'));
    }
}