<?php

namespace App\Http\Controllers;

use App\Models\Akun;
use App\Helpers\Helper;
use App\Models\JurnalUmum;
use Illuminate\Http\Request;

class JurnalUmumController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    protected $routeName = 'jurnalUmum';
    protected $viewName = 'jurnal_umum';
    protected $menu = 'Master Data';
    protected $title = 'Jurnal Umum';

    protected $aksesMenu = 'Pembelian';

    public function index()
    {
        //
        if(!Helper::cek_akses($this->aksesMenu)){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'ubah'=>Helper::cek_akses($this->aksesMenu,'Ubah'),
            'hapus'=>Helper::cek_akses($this->aksesMenu,'Hapus')
        ];
        
        $datas = JurnalUmum::orderBy('created_at', 'desc')->get();

        return view($this->viewName.'.index', compact('settings', 'datas'));



    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        if(!Helper::cek_akses($this->aksesMenu, 'Tambah')){
            return abort(404);
        }

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=> route($this->routeName.'.store'),
        ];

        $akuns = Akun::all();

        return view($this->viewName.'.form', compact('settings', 'akuns'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        try {
            for($i = 0; $i < count($request->akun_id); $i++){
                $akun = Akun::find($request->akun_id[$i]);
                $jurnal = JurnalUmum::create([
                    'akun_id' => $akun->id,
                    'tanggal' => $request->tgl_pengeluaran,
                    'description' => $request->desc[$i],
                    'debet' => $request->debet[$i]?Helper::onlyNumber($request->debet[$i]):0,
                    'kredit' => $request->kredit[$i]?Helper::onlyNumber($request->kredit[$i]):0,
                ]);

            }
            Helper::addUserLog('Menambah data jurnal umum');
            
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menambah Data jurnal umum']);
        } catch (\Throwable $th) {
            //throw $th;
            dd($th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(JurnalUmum $jurnalUmum)
    {
        //
        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
            'action'=>route($this->routeName.'.update',$jurnalUmum->id),
        ];
        $akuns = Akun::all();
        

        return view($this->viewName.'.form',compact('settings', 'akuns'),['detail'=>$jurnalUmum]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, JurnalUmum $jurnalUmum)
    {
        //

        try {
            $jurnalUmum->update([
                    'akun_id' => $request->akun_id[0],
                    'tanggal' => $request->tgl_pengeluaran,
                    'description' => $request->desc[0],
                    'debet' => $request->debet[0]?Helper::onlyNumber($request->debet[0]):0,
                    'kredit' => $request->kredit[0]?Helper::onlyNumber($request->kredit[0]):0,
            ]);
            Helper::addUserLog('Mengubah data jurnal umum');
            
            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Mengubah Data jurnal umum']);
        } catch (\Throwable $th) {
            //throw $th;
            dd($th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(JurnalUmum $jurnalUmum)
    {
        //
        try {
            Helper::addUserLog("Menghapus data jurnal umum ".$jurnalUmum->id);
            $jurnalUmum->delete();

            return redirect(route($this->routeName.'.index'))->with(['success'=>'Berhasil Menghapus Data Jurnal Umum']);
        } catch (\Throwable $th) {
            //throw $th;
            dd($th->getMessage());
        }
    }
}
