<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use App\Models\Penjualan;
use App\Models\Pengeluaran;
use App\Models\UserLogs;

class DashboardController extends Controller
{
    protected $routeName = 'dashboard';
    protected $viewName = 'dashboard';
    protected $menu = 'Home';
    protected $title = 'Dashboard';
    
    public function index()
    {

        $settings = [
            'menu' => $this->menu,
            'title' => $this->title,
            'route' => $this->routeName,
        ];
        
        $penjualan = Penjualan::whereMonth('tgl_transaksi', date('m'))->get();
        $penjualan_bulan_ini = 0;

        foreach ($penjualan as $data) {
            $penjualan_bulan_ini += $data->total;
        }

        $pengeluaran = Pengeluaran::whereMonth('tgl_pengeluaran', date('m'))->get();
        $pengeluaran_bulan_ini = 0;

        foreach ($pengeluaran as $data) {
            $pengeluaran_bulan_ini += $data->total;
        }
        
        $persen_penjualan_bulan_ini = ($penjualan_bulan_ini + $pengeluaran_bulan_ini) ? $penjualan_bulan_ini / ($penjualan_bulan_ini + $pengeluaran_bulan_ini) * 100 : 0;

        $persen_pengeluaran_bulan_ini = ($penjualan_bulan_ini + $pengeluaran_bulan_ini) ? $penjualan_bulan_ini / ($penjualan_bulan_ini + $pengeluaran_bulan_ini) * 100 : 0;

        $aktifitas = UserLogs::limit(5)->orderBy('created_at', 'desc')->get();

        $datas = [
            'total_penjualan' => Helper::hitungTotalPenjualan(),
            'penjualan_hari_ini' => Helper::hitungPenjualanHariIni(),
            'total_pengeluaran' => Helper::hitungTotalPengeluaran(),
            'penjualan_bulan_ini' => $penjualan_bulan_ini,
            'pengeluaran_bulan_ini' => $pengeluaran_bulan_ini,
            'persen_penjualan_pengeluaran' => [$persen_penjualan_bulan_ini, $persen_pengeluaran_bulan_ini],
            'aktifitas' => $aktifitas,
        ];
        
        return view($this->viewName, compact('settings', 'datas'));
    }
}
