<?php
namespace App\Helpers;

use App\Models\Penjualan;
use App\Models\Produk;
use App\Models\Pembelian;
use App\Models\Pengeluaran;
use App\Models\DetailPengeluaran;
use App\Models\DetailPenjualan;
use App\Models\DetailPembelian;
use App\Models\PembayaranPenjualan;
use App\Models\PembayaranPembelian;
use App\Models\Level;
use App\Models\UserLogs;
use App\Models\Akun;
use App\Models\JurnalUmum;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Helper {

    public $date;
    public $date2;

    public static function cek_route($routes,$or = false){
        if(is_array($routes)){
            if($or){
                foreach ($routes as $route){
                    if(request()->routeIs($route)){
                        return true;
                    }
                }
            } else {
                foreach ($routes as $route){
                    if(!request()->routeIs($route)){
                        return false;
                    }
                }
                return true;
            }
        } else {
            if(request()->routeIs($routes)){
                return true;
            }
        }

        //default
        return false;
    }

    public static function cek_akses($moduls,$aksi = null,$array = false){
        if($array){
            if(is_array($moduls)){
                if(count($moduls) > 0 && is_array($moduls[0])){

                    $result = [];
                    foreach ($moduls as $modul => $a){
                        $result[$modul] = Helper::cek_modul($modul,$a);
                    }
                    return $result;
                } else {
                    $result = [];
                    foreach ($moduls as $modul){
                        $result[$modul] = Helper::cek_modul($modul,$aksi);
                    }
                    return $result;

                }
            } else {
                return [
                    $moduls=>Helper::cek_modul($moduls,$aksi)
                ];
            }
        } else {
            return Helper::cek_modul($moduls,$aksi);
        }
        //default
        if($array){
            return [];
        }
        return false;
    }

    public static function cek_modul($moduls,$aksi = null){
        $user = Auth::user();
        if(is_array($moduls)){
            if(count($moduls) > 0 && is_array($moduls[0])){
                $cek = Level::where('id',$user->level_id)->whereHas('Level.Menu',function($q)use($moduls){
                    $q->where($moduls);
                });

                if($cek->count() > 0){
                    return true;
                }
            } else {
                $cek = Level::where('id',$user->level_id)->whereHas('Level.Menu',function($q)use($moduls,$aksi){
                    $q->whereIn('nama_menu',$moduls)->where('aksi_menu',$aksi ?? 'Lihat');
                });

                if($cek->count() > 0){
                    return true;
                }
            }
        } else {
            
            $cek = Level::where('id',$user->level_id)->whereHas('Menu',function($q)use($moduls,$aksi){
                $q->where('nama_menu',$moduls)->where('aksi_menu',$aksi ?? 'Lihat');
            });
            
            if($cek->count() > 0){
                return true;
            }
        }
        //default
        return false;
    }

    public static function sendWa($number, $message)
    {   
        $number = str_replace("+62","0",$number);
        $key='7e10303d8e75d503ef83ab381ac95f692a476a9766c51090';
        $url='http://116.203.92.59/api/async_send_message';
        $data = array(
            "phone_no"=> $number,
            "key"       =>$key,
            "message"   =>$message,
        // "url"        =>$img_url,
        );
        $data_string = json_encode($data);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string))
        );
        $res = curl_exec($ch);
        curl_close($ch);

        return $res;   
    }

    public static function addUserLog($action,$actionDetail = null,$ip = null)
    {
        
        if($ip == null){
            $ip = Helper::getMyIP();
        }    

        UserLogs::create([
            'action'=>$action,
            'action_detail'=>json_encode($actionDetail),
            'user_id'=>Auth::user()->id,
            'ip'=>$ip,
            'ip_detail'=>NULL
        ]);
        
    }

    public static function loginLog($action,$id,$actionDetail = null,$ip = null)
    {
        
        if($ip == null){
            $ip = Helper::getMyIP();
        }
        

        UserLogs::create([
            'action'=>$action,
            'action_detail'=>json_encode($actionDetail),
            'user_id'=>$id,
            'ip'=>$ip,
            'ip_detail'=>NULL
        ]);
        
    }

    public static function getMyIP()
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
           $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public static function onlyNumber($string){
        if($string){
            return preg_replace('/[^0-9]/', '', $string);
        }else{
            return 0;
        }
    }
    public static function onlyFloat($string){
        if($string){
            return preg_replace('/[^0-9.]/', '', $string);
        }else{
            return 0;
        }
    }

    public static function generateNoPenjualan(){
        $p = Penjualan::orderBy('no_transaksi','DESC')->first();
        $kd = "INV-000";
        if($p){
            $kd = $p->no_transaksi;
        }

        return ++$kd;
    }

    public static function generateNoPembelian(){
        $p = Pembelian::orderBy('no_transaksi','DESC')->first();
        $kd = "INV-PBN-000";
        if($p){
            $kd = $p->no_transaksi;
        }

        return ++$kd;
    }

    public static function generateNoPengeluaran(){
        $p = Pengeluaran::orderBy('no_pengeluaran','DESC')->first();
        $kd = "EX-000";
        if($p){
            $kd = $p->no_pengeluaran;
        }

        return ++$kd;
    }

    public static function hitungSaldoKas($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = Penjualan::whereBetween('created_at',[$date,$date2])->get();
            $datas2 = Pembelian::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Penjualan::all();
            $datas2 = Pembelian::all();
        }
        
        $total = 0;

        foreach($datas as $data){
            $total += $data->uang_muka;
            foreach($data->pembayaran as $pembayaran){
                $total += $pembayaran->jumlah_bayar;
            }
        }

        $total2 = 0;

        foreach($datas2 as $data){
            $total2 += $data->uang_muka;
            foreach($data->pembayaran as $pembayaran){
                $total2 += $pembayaran->jumlah_bayar;
            }
        }



        return "Rp. " . number_format($total - $total2);
    }

    public static function hitungPersediaanBarang($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = Produk::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Produk::all();
        }
        
        $total = 0;

        foreach($datas as $data){
            $total += $data->harga_beli * $data->stok;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungSaldoPiutangUsaha(){
        if (isset($date) && isset($date2)) {
            $datas = Penjualan::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Penjualan::all();
        }
        $total = 0;

        foreach($datas as $data){
            $total += $data->sisa_tagihan;
        }

        if($total < 0){
            $total = 0;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungSaldoHutangUsaha($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = Pembelian::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Pembelian::all();
        }

        $total = 0;

        foreach($datas as $data){
            $total += $data->sisa_tagihan;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungSaldoPendapatan($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = Penjualan::whereBetween('created_at',[$date,$date2])->get();
            // $datas2 = Pembelian::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Penjualan::all();
            // $datas2 = Pembelian::all();
        }

        $total = 0;

        foreach($datas as $data){
            // $total += $data->total;
            foreach ($data->detail as $detail) {
                $total += ($detail->qty * $detail->harga);
            }
        }

        // $total2 = 0;

        // foreach($datas2 as $data){
        //     // $total2 += $data->total;
        //     foreach ($data->detail as $detail) {
        //         $total2 += $detail->qty * $detail->harga;
        //     }
        // }

        return "Rp. " . number_format($total);
    }

    public static function hitungSaldoBebanPokokPendapatan($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = Pembelian::whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = Pembelian::all();
        }
        
        $total = 0;

        foreach($datas as $data){
            // $total += $data->total;
            foreach ($data->detail as $detail) {
                $total += $detail->qty * $detail->harga;
            }
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungSaldoPengeluaran($akun_id,$date,$date2){
        
        $total = 0;
        
        if (isset($date) && isset($date2)) {
            $datas = DetailPengeluaran::whereBetween('created_at',[$date,$date2])->where('akun_id', $akun_id)->get();
        }else{
            $datas = DetailPengeluaran::where('akun_id', $akun_id)->get();
        }

        foreach($datas as $data){
            $total += $data->biaya;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungPenjualanHariIni(){
        $datas = Penjualan::whereDate('tgl_transaksi', date("Y-m-d"))->get();
        $total = 0;

        foreach($datas as $data){
            $total += $data->total;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungTotalPenjualan(){
        $datas = Penjualan::all();
        $total = 0;

        foreach($datas as $data){
            $total += $data->total;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungTotalPengeluaran(){
        $datas = Pengeluaran::all();
        $total = 0;

        foreach($datas as $data){
            $total += $data->total;
        }

        return "Rp. " . number_format($total);
    }

    public static function hitungTotalPajakMasukkan($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = DetailPembelian::whereBetween('created_at',[$date,$date2])->get();

        }else{
            $datas = DetailPembelian::all();

        }
        $total = 0;

           foreach ($datas as $data) {
               if ($data->pajak != null) {
                $total += $data->harga * ($data->pajak / 100);
               }else if ($data->pajak_lain != null) {
                $total += $data->harga * ($data->pajak_lain / 100);
               }

           }

           return "Rp. " . number_format($total);
    }

    public static function hitungTotalPajakKeluaran($date,$date2){
        if (isset($date) && isset($date2)) {
            $datas = DetailPenjualan::whereBetween('created_at',[$date,$date2])->get();

        }else{
            $datas = DetailPenjualan::all();

        }
        $total = 0;

       foreach ($datas as $data) {
           if ($data->pajak != null) {
            $total += $data->harga * ($data->pajak / 100);
           }else if ($data->pajak_lain != null) {
            $total += $data->harga * ($data->pajak_lain / 100);
           }

       }

       return "Rp. " . number_format($total);
    }

    public static function hitungTotalPemakaianPribadi($date,$date2){
        $detail_pengeluaran = DetailPengeluaran::whereHas('akun', function($q){
            $q->where('nama_akun','Pemakaian Pribadi');
        });
        if (isset($date) && isset($date2)) {
            $datas = $detail_pengeluaran->whereBetween('created_at',[$date,$date2])->get();
        }else{
            $datas = $detail_pengeluaran->get();
        }

        $total = 0;

        foreach($datas as $data){
            $total += $data->biaya;
        }


        return "Rp. " . number_format($total);
    }

    public static function mainChart(){
        $month = [
            "01",
            "02",
            "03",
            "04",
            "05",
            "06",
            "07",
            "08",
            "09",
            "10",
            "11",
            "12",
        ];

        $datas['a'] = [];
        $datas['b'] = [];
        for ($i=0; $i < count($month); $i++) { 
            $totalPenjualanPerBulan = 0;
            $totalPengeluaranPerBulan = 0;

            $penjualan = Penjualan::whereMonth('tgl_transaksi', $month[$i])->get();
            foreach ($penjualan as $data) {
                $totalPenjualanPerBulan += $data->total;
            }

            $pengeluaran = Pengeluaran::whereMonth('tgl_pengeluaran', $month[$i])->get();
            foreach ($pengeluaran as $data) {
                $totalPengeluaranPerBulan += $data->total;
            }

            $datas['a'][] = $totalPenjualanPerBulan;
            $datas['b'][] = $totalPengeluaranPerBulan;
        }
        return $datas;
    }

    public static function findAkunEkuitas($akun_id){
        $jurnal = JurnalUmum::where('akun_id', $akun_id)->where('opening_akun', 'yes')->first();
        return $jurnal;
    }
}
